#include <ESP8266WiFi.h>
#include <WiFiClientSecure.h>
#include <ArduinoJson.h>
#include <Wire.h>
#include <BH1750.h>
BH1750 lightMeter(0x23);

WiFiClientSecure client;


unsigned long lastMillis = 0;

byte sendEmail(float x);
byte eRcv(WiFiClientSecure client);



const char* SSID = "your name ssid"; 
const char* PASS = "your pass"; 
const char* user_base64 = "your name"; // https://www.base64encode.org/
const char* user_password_base64 = "your pass"; 
const char* from_email = "MAIL From: <email>"; 
const char* to_email = "RCPT TO: <email>"; 
const char* Host = "api.sendgrid.com";






void setup()
{
  
  Serial.begin(115200);
  delay(10);
  Serial.println("");
  Serial.print("Connecting To ");
  WiFi.begin(SSID, PASS);
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi Connected");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

 

    // Initialize the I2C bus (BH1750 library doesn't do this automatically)
  Wire.begin(D4,D3);
  // On esp8266 you can select SCL and SDA pins using Wire.begin(D4, D3);
  // scl to d3 et sda d4

  //   connect();
  
   
    // begin returns a boolean that can be used to detect setup problems.
  if (lightMeter.begin(BH1750::CONTINUOUS_HIGH_RES_MODE)) {
    Serial.println(F("BH1750 Advanced begin"));
  
  }
  else {
    Serial.println(F("Error initialising BH1750"));
  }
}

void loop()
{
  float lux = lightMeter.readLightLevel();
  Serial.print("Light: ");
  Serial.print(lux);
  Serial.println(" lx");
  
  // mettre a 300
  if (lux > 300){

  String jsonString = "";
  String senderEmail = "email";

  String receiverEmail = "email";
  double _lat = 10;
  double _log = 12;
  float _lux = 101;
  
  jsonString = "{\n";
  jsonString += "\"from\":{\"email\":\"" + senderEmail +"\"},\n";
  
  jsonString += "\"personalizations\": [{ \"to\":[{\"email\":\"" + receiverEmail + "\"}],\n"; 
  // jsonString += "\"cc\":\""+ ccEmail +"\",\n";
  jsonString += "\"dynamic_template_data\":{\n";
  jsonString += "\"lat\":\""+ String(_lat) +"\",\n";
  jsonString += "\"long\":\""+ String(_log) +"\",\n";
  jsonString += "\"lux\":\""+ String(lux) +"\"}}],\n";
  jsonString += "\"template_id\":\"pass here\"}\n";

  Serial.println(jsonString);

   String thisPage = "/v3/mail/send";

  //Connect to the client and make the api call
  Serial.print("Requesting URL: ");
  Serial.println("https://" + (String)Host + thisPage);
  Serial.println(" ");
  if (client.connect(Host, 443)) {
    Serial.println("Connected");
    client.println("POST " + thisPage + " HTTP/1.1");
    client.println("Host: " + (String)Host);
    client.println("Connection: close");
    client.println("authorization: Bearer ");
    client.println("content-type: application/json");
    client.println("User-Agent: Arduino/1.0");
    client.print("Content-Length: ");
    client.println(jsonString.length());
    client.println();
    client.print(jsonString);
    delay(500);
  } else {
    Serial.println("Connection failed");  
  }

  while (client.available()) {
    String line = client.readStringUntil('\r');

  }
  Serial.println("closing connection");
  Serial.println();
  client.stop();
   /*
     if (sendEmail(lux)) Serial.println(F("Email sent"));
     else Serial.println(F("Email failed"));
*/
    // delay une journée
    //    delay(1000 * 60 * 60 * 24);
    delay(1000 * 10);
  }
  delay(2000); 
}


