/*********************************************************************
  This is the code for Fetching your location from Google Geolocation API
  
  This code is provided by 
  techiesms
Connection:

    VCC -> 3V3 or 5V
    GND -> GND
    SCL -> SCL (A5 on Arduino Uno, Leonardo, etc or 21 on Mega and Due, on esp8266 free selectable)
    SDA -> SDA (A4 on Arduino Uno, Leonardo, etc or 20 on Mega and Due, on esp8266 free selectable)
    ADD -> (not connected) or GND

*********************************************************************/
#include <WiFiClientSecure.h>
//#include <Bridge.h>
//#include <Process.h>
#include <MQTT.h>
#include <ESP8266HTTPClient.h>
#include <ArduinoJson.h>
#include "ESP8266WiFi.h"
#include <Wire.h>
#include <BH1750.h>
BH1750 lightMeter(0x23);




char myssid[] = "myssid";         // your network SSID (name)
char mypass[] = "mypass";          // your network password



 WiFiClientSecure client;
  
//Credentials for Google GeoLocation API...
const char* Host = "www.googleapis.com";
String thisPage = "/geolocation/v1/geolocate?key=";
String key = "your api key";

int status = WL_IDLE_STATUS;
String jsonString = "{\n";

double latitude    = 0.0;
double longitude   = 0.0;
double accuracy    = 0.0;

double oldlat      = 0.0; 
double oldlong     = 0.0; 



int more_text = 1; // set to 1 for more debug output


String JsonEvenement = "";


void setup()   {
  Serial.begin(115200);

 
  // Initialize the I2C bus (BH1750 library doesn't do this automatically)
  Wire.begin(D4,D3);
  // On esp8266 you can select SCL and SDA pins using Wire.begin(D4, D3);
  // scl to d3 et sda d4
    // begin returns a boolean that can be used to detect setup problems.
  if (lightMeter.begin(BH1750::CONTINUOUS_HIGH_RES_MODE)) {
    Serial.println(F("BH1750 Advanced begin"));
  }
  else {
    Serial.println(F("Error initialising BH1750"));
  }


  Serial.println("Start");
  // Set WiFi to station mode and disconnect from an AP if it was previously connected
  WiFi.mode(WIFI_STA);
  WiFi.disconnect();
  delay(100);
  Serial.println("Setup done");
  // We start by connecting to a WiFi network
  Serial.print("Connecting to ");
  Serial.println(myssid);
  WiFi.begin(myssid, mypass);

  while (WiFi.status() != WL_CONNECTED) {
    delay(200);
    Serial.print(".");
  }
  Serial.println(".");


}

void sendGPS(String pos, float lux2) {

  String testData = "{\"fields\": {\"Coordinates\": \""+pos+"\",\"lux\": \""+lux2+"\"}}";
  String thisPage = "/v0/a";

  const char* Host = "api.airtable.com";
  Serial.print("Requesting URL: ");
  Serial.println("https://" + (String)Host + thisPage);
  Serial.println(" ");
  if (client.connect(Host, 443)) {
    client.println("POST " + thisPage + " HTTP/1.1");
    client.println("Host: api.airtable.com");
    client.println("Connection: close");
    client.println("Authorization: Bearer");
    client.println("Content-Type: application/json");
    client.println("User-Agent: Arduino/1.0");
    client.print("Content-Length: ");
    client.println(testData.length());
    client.println();
    client.print(testData);
    delay(500);
  } else {
    Serial.println("Connection failed");  
  }

  while (client.available()) {
    String line = client.readStringUntil('\r');
    if (more_text) {
      Serial.print(line);
    }  
  }

  Serial.println("closing connection");
  Serial.println();
  client.stop();
}


void loop() {

    float lux = lightMeter.readLightLevel();
  Serial.print("Light: ");
  Serial.print(lux);
  Serial.println(" lx");
 



  char bssid[6];
  DynamicJsonBuffer jsonBuffer;
  Serial.println("scan start");
  // WiFi.scanNetworks will return the number of networks found
  int n = WiFi.scanNetworks();
  Serial.println("scan done");
  if (n == 0)
    Serial.println("no networks found");
  else
  {
    Serial.print(n);
    Serial.println(" networks found...");

    
    Serial.println(" ");
  }
  // now build the jsonString...
  jsonString = "{\n";
  jsonString += "\"homeMobileCountryCode\": 234,\n"; // this is a real UK MCC
  jsonString += "\"homeMobileNetworkCode\": 27,\n";  // and a real UK MNC
  jsonString += "\"radioType\": \"gsm\",\n";         // for gsm
  jsonString += "\"carrier\": \"Vodafone\",\n";      // associated with Vodafone
  jsonString += "\"wifiAccessPoints\": [\n";
  for (int j = 0; j < n; ++j)
  {
    jsonString += "{\n";
    jsonString += "\"macAddress\" : \"";
    jsonString += (WiFi.BSSIDstr(j));
    jsonString += "\",\n";
    jsonString += "\"signalStrength\": ";
    jsonString += WiFi.RSSI(j);
    jsonString += "\n";
    if (j < n - 1)
    {
      jsonString += "},\n";
    }
    else
    {
      jsonString += "}\n";
    }
  }
  jsonString += ("]\n");
  jsonString += ("}\n");
  //--------------------------------------------------------------------

  Serial.println("");


  //Connect to the client and make the api call
  Serial.print("Requesting URL: ");
  Serial.println("https://" + (String)Host + thisPage + "AIzaSyCYNXIYINPmTNIdusMjJloS4_BXSOff1_g");
  Serial.println(" ");
  if (client.connect(Host, 443)) {
    Serial.println("Connected");
    client.println("POST " + thisPage + key + " HTTP/1.1");
    client.println("Host: " + (String)Host);
    client.println("Connection: close");
    client.println("Content-Type: application/json");
    client.println("User-Agent: Arduino/1.0");
    client.print("Content-Length: ");
    client.println(jsonString.length());
    client.println();
    client.print(jsonString);
    delay(500);
  } else {
    Serial.println("Connection failed");  
  }

  //Read and parse all the lines of the reply from server
  while (client.available()) {
    String line = client.readStringUntil('\r');
    if (more_text) {
      Serial.print(line);
    }
    JsonObject& root = jsonBuffer.parseObject(line);
    if (root.success()) {
      latitude    = root["location"]["lat"];
      longitude   = root["location"]["lng"];
      accuracy   = root["accuracy"];
    }
    
     

  }
  
/


  Serial.print("closing connection");
  Serial.println();

  Serial.print("Latitude = ");
  Serial.println(latitude, 6);
  Serial.print("Longitude = ");
  Serial.println(longitude, 6);
  Serial.print("Accuracy = ");
  Serial.println(accuracy);


client.stop();



    Serial.println("pas meme endroit");
    Serial.println("oldlat = " + String(oldlat, 5));
    Serial.println("new oldlat = " + String(oldlat, 5) );


 String pos = String(latitude, 6)+","+String(longitude, 6);
 float lux2 =  lux; 

 sendGPS(pos, lux2);


  oldlat = latitude; 
  oldlong = longitude;


}

